%     iterative finite difference solution
%   Solves Example 6.2. Can be modified to solve other problems
%   plots added - contour plots seem to be fine
%
%     the following data are used:
%     vk = matrix of all potentials
%     v  = vector of potentials at internal nodes
%     n1x= number of divisions in the x direction
%     n1y= number of divisions in the y direction
%     vx1,vx2, boundary potentials on the lower and upper boundaries
%     vy1,vy2, boundary potentials on the left and right boundaries
%     eps, tolerance error per node.
%
% enter data
clear
      disp('enter coordinates of lower left and upper right ')
      c1=input('corners of solution domain [x1 y1 x2 y2] --->  ')
        x1=c1(1);
        y1=c1(2);
        x2=c1(3);
        y2=c1(4);
      c1=input('enter number of divisions in the x, y directions [n1x n1y] --->  ')
        n1x=c1(1)
        n1y=c1(2)
      c1=input('enter boundary conditions on lower, upper boundaries [vx1 vx2] --->  ')
        vx1=c1(1);
        vx2=c1(2);
      disp('enter 0 if no charge in solution domain. enter 1')
      disp('if there is charge in part of the region. enter 2 if')
      ic=input('charge is distributed throughout solution domain --->  ')
      if ic==1
        disp('enter lower left and upper right corner')
        c1=input('coordinates of charge region [xa ya xb yb] --->  ')
        xa=c1(1);
        ya=c1(2);
        xb=c1(3);
        yb=c1(4);
      end
      if ic==2
        ro=input('enter charge density in charge region --->  ')
      	er=input('enter relative permittivity of charge region --->  ')
        eps=input('enter required tolerance error for solution --->  ')
      else
        eps=input('enter required tolerance error for solution --->  ')
      end

% start calculation

      n1=n1x+1;
      n2=n1y+1;
      for i=1:n1;
          for j=1:n2
              vk(i,j)=0.;
          end
      end

% find coordinates of all nodes in the solution domain

      dx=(x2-x1)/n1x;
      dy=(y2-y1)/n1y;
      n=0;
for i=1:n1
    xx(i)=dx*(i-1);
end
for i=1:n2
    yy(i)=dy*(i-1);
end
      for i=1:n2
          for j=1:n1
            n=n+1;
            x(n)=x1+(j-1)*dx;
            y(n)=y1+(i-1)*dy;
            vk(i,j)=0.0;
            nb(n)=0;
          end
      end

% set boundary conditions on upper, lower, left and right surfaces

      for i=1:n1
           vk(1,i)=vx1;
           nb(i)=1;
      end

      r1=0.49*(x2-x1);
      n=2*n1;
      for i=3:n2
          for j=1:n1
            n=n+1;
            r=sqrt((x(n)-x(28))^2+(y(n)-y(28))^2);
        if(r>=r1)
            vk(i,j)=vx2;
            nb(n)=1;
        end
          end
      end

      vk(2,1)=(vx2-vx1)/2;
      vk(2,n1)=vk(2,1);
      nb(n1+1)=1;
      nb(2*n1)=1;

if ic==1
      n=0
        for i=1:n2
            for j=1:n1
      n=n+1
      if (x(n)>=xa)|(x(n)<=xb)|(y(n)>=ya)|(y(n)<=yb);
      nb(n)=-1;
      end
            end
        end
end

        if ic==2
         n=n1*n2;
            for i=1:n
      if nb(i)==0
          nb(i)=-1;
      end
            end
        end

% start iterations

      e0=8.854e-12;
      n=n1*n2;
      kk=0;
      vv=0.0;
      vv1=eps*1e6;
 while (abs(vv-vv1)>eps)
      vv1=vv;
      k=0;
 for i=1:n2
     for j=1:n1
         k=k+1;
            if nb(k)==0
                    vk(i,j)=(vk(i,j-1)+vk(i,j+1)+vk(i-1,j)+vk(i+1,j))/4.0;
            end
            if nb(k)==-1
                    vk(i,j)=((vk(i,j-1)+vk(i,j+1)+vk(i-1,j)+vk(i+1,j))/4)+ro*dx*dy/(4*e0*er);
            end
            vv=vv+vk(i,j);
     end  
 end
      vv=vv/n;
      kk=kk+1;
 end
vk
kk
for i=1:n2
    for j=1:n1
        z(i,j)=vk(i,j);
    end
end
z

[C,h]=contour(xx,yy,z,11)
clabel(C,h)
title({'Equal potential representation inside the capacitor'})
% the error criterion has been met. the correct solution is in vk
%  write the solution vector

      kk=0;
      n=n1*n2
      for i=1:n2
          for j=1:n1
              kk=kk+1;
              c1(1)=i;
              c1(2)=j;
              c1(3)=x(kk);
              c1(4)=y(kk);
              c1(5)=vk(i,j);
%              c1
          end
      end
%      write(3,7003)n
% 7003 format(i5)
%      do 7001 i=1,n2
%      do 7001 j=1,n1
%      kk=kk+1
%      write(3,7002)i,j,x(kk),y(kk),vk(i,j)
% 7001 continue
% 7002 format(2i5,3e10.4)
% 1009 continue
        kk;
      
%      write(1,1)kk
      disp('solution:')
      for k=1:n
          cp(1)=k;
          cp(2)=nb(k);
%          cp
      end
%      write(1,2)(k,nb(k),k=1,n)
    for i=1:n2
        for k=1:n1
        cq(1)=i;
        cq(2)=k;
        cq(3)=vk(i,k);
 %       cq
        end
    end
%        vk
%do 181 i=1,n2
%      write(1,7)(i,k,vk(i,k),k=1,n1)
%  181 continue
%    1 format(1x,'number of iterations = ',i5,/)
%    2 format(3('   node:',i3,', nb=',i3))
%    7 format(3('   node:',2i3,',vk=',f8.3))

